/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.lang.Nullable;
import spring.turbo.util.DistanceUnit;

public final class DistanceUtils {
    private DistanceUtils() {
    }

    public static double distance(double d, double d2, double d3, double d4, DistanceUnit distanceUnit) {
        return DistanceUtils.distance(d, d2, d3, d4, distanceUnit, Integer.MIN_VALUE, null);
    }

    public static double distance(double d, double d2, double d3, double d4, DistanceUnit distanceUnit, int n, @Nullable RoundingMode roundingMode) {
        double d5 = d2 - d4;
        double d6 = Math.sin(DistanceUtils.deg2rad(d)) * Math.sin(DistanceUtils.deg2rad(d3)) + Math.cos(DistanceUtils.deg2rad(d)) * Math.cos(DistanceUtils.deg2rad(d3)) * Math.cos(DistanceUtils.deg2rad(d5));
        d6 = Math.acos(d6);
        d6 = DistanceUtils.rad2deg(d6);
        d6 = d6 * 60.0 * 1.1515;
        switch (distanceUnit) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MILES: {
                double d7 = d6;
                break;
            }
            case KILOMETERS: {
                double d7 = d6 * 1.609344;
                break;
            }
            case NAUTICAL_MILES: {
                double d7 = d6 = d6 * 0.8684;
            }
        }
        if (roundingMode == null) {
            return d6;
        }
        return BigDecimal.valueOf(d6).setScale(n, roundingMode).doubleValue();
    }

    private static double deg2rad(double d) {
        return d * Math.PI / 180.0;
    }

    private static double rad2deg(double d) {
        return d * 180.0 / Math.PI;
    }
}

