/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class EnumUtils {
    private EnumUtils() {
    }

    @Nullable
    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string) {
        return EnumUtils.getEnum(clazz, string, null);
    }

    @Nullable
    public static <E extends Enum<E>> E getEnum(Class<E> clazz, String string, @Nullable E e) {
        Assert.hasText((String)string, (String)"enumName is required");
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return e;
        }
    }

    @Nullable
    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> clazz, String string) {
        return EnumUtils.getEnumIgnoreCase(clazz, string, null);
    }

    @Nullable
    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> clazz, String string, @Nullable E e) {
        Assert.notNull(clazz, (String)"enumClass is required");
        Assert.hasText((String)string, (String)"enumName is required");
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (!enum_.name().equalsIgnoreCase(string)) continue;
            return (E)enum_;
        }
        return e;
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> clazz) {
        return new ArrayList<Enum>(Arrays.asList((Enum[])clazz.getEnumConstants()));
    }

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> clazz) {
        LinkedHashMap<String, Enum> linkedHashMap = new LinkedHashMap<String, Enum>();
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            linkedHashMap.put(enum_.name(), enum_);
        }
        return linkedHashMap;
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> clazz, String string) {
        return EnumUtils.getEnum(clazz, string) != null;
    }

    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> clazz, String string) {
        return EnumUtils.getEnumIgnoreCase(clazz, string) != null;
    }
}

