/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.io.Serializable;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.LogLevel;
import spring.turbo.util.StringFormatter;

public final class Logger
implements Serializable {
    @Nullable
    private final org.slf4j.Logger log;
    private final boolean enabled;
    private final LogLevel level;

    public Logger(String string, LogLevel logLevel) {
        Assert.notNull((Object)((Object)logLevel), (String)"level is required");
        Assert.hasText((String)string, (String)"loggerName is required");
        this.level = logLevel;
        this.log = logLevel == LogLevel.STDOUT || logLevel == LogLevel.STDERR ? null : LoggerFactory.getLogger((String)string);
        this.enabled = this.checkEnabled();
    }

    public Logger(Class<?> clazz, LogLevel logLevel) {
        Assert.notNull((Object)((Object)logLevel), (String)"level is required");
        Assert.notNull(clazz, (String)"loggerName is required");
        this.level = logLevel;
        this.log = logLevel == LogLevel.STDOUT || logLevel == LogLevel.STDERR ? null : LoggerFactory.getLogger(clazz);
        this.enabled = this.checkEnabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean checkEnabled() {
        return switch (this.level) {
            case LogLevel.STDOUT, LogLevel.STDERR -> true;
            case LogLevel.TRACE -> {
                if (this.log != null && this.log.isTraceEnabled()) {
                    yield true;
                }
                yield false;
            }
            case LogLevel.DEBUG -> {
                if (this.log != null && this.log.isDebugEnabled()) {
                    yield true;
                }
                yield false;
            }
            case LogLevel.INFO -> {
                if (this.log != null && this.log.isInfoEnabled()) {
                    yield true;
                }
                yield false;
            }
            case LogLevel.WARN -> {
                if (this.log != null && this.log.isWarnEnabled()) {
                    yield true;
                }
                yield false;
            }
            case LogLevel.ERROR -> {
                if (this.log != null && this.log.isErrorEnabled()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void log(String string, Object ... objectArray) {
        if (this.isEnabled()) {
            switch (this.level) {
                case TRACE: {
                    this.trace(string, objectArray);
                    break;
                }
                case DEBUG: {
                    this.debug(string, objectArray);
                    break;
                }
                case INFO: {
                    this.info(string, objectArray);
                    break;
                }
                case WARN: {
                    this.warn(string, objectArray);
                    break;
                }
                case ERROR: {
                    this.error(string, objectArray);
                    break;
                }
                case STDOUT: {
                    this.stdout(string, objectArray);
                    break;
                }
                case STDERR: {
                    this.stderr(string, objectArray);
                }
            }
        }
    }

    private void stdout(String string, Object ... objectArray) {
        System.out.println(StringFormatter.format(string, objectArray));
    }

    private void stderr(String string, Object ... objectArray) {
        System.err.println(StringFormatter.format(string, objectArray));
    }

    private void trace(String string, Object ... objectArray) {
        if (this.log != null) {
            this.log.trace(string, objectArray);
        }
    }

    private void debug(String string, Object ... objectArray) {
        if (this.log != null) {
            this.log.debug(string, objectArray);
        }
    }

    private void info(String string, Object ... objectArray) {
        if (this.log != null) {
            this.log.info(string, objectArray);
        }
    }

    private void warn(String string, Object ... objectArray) {
        if (this.log != null) {
            this.log.warn(string, objectArray);
        }
    }

    private void error(String string, Object ... objectArray) {
        if (this.log != null) {
            this.log.warn(string, objectArray);
        }
    }
}

