/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import spring.turbo.util.BigDecimalUtils;
import spring.turbo.util.StringFormatter;

public final class NumberParseUtils {
    private NumberParseUtils() {
    }

    public static <T extends Number> T parse(String string, Class<T> clazz) {
        Assert.notNull((Object)string, (String)"text is required");
        Assert.notNull(clazz, (String)"type is required");
        string = string.replaceAll("[\\s,]", "");
        if (string.startsWith("#") || string.startsWith("-#") || string.startsWith("0x") || string.startsWith("0X") || string.startsWith("-0x") || string.startsWith("-0X")) {
            BigInteger bigInteger = (BigInteger)NumberUtils.parseNumber((String)string, BigInteger.class);
            return BigDecimalUtils.getValue(new BigDecimal(bigInteger), clazz);
        }
        if (string.contains("E") || string.contains("e")) {
            BigDecimal bigDecimal = (BigDecimal)NumberUtils.parseNumber((String)string, BigDecimal.class);
            return BigDecimalUtils.getValue(bigDecimal, clazz);
        }
        try {
            return (T)NumberUtils.parseNumber((String)string, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return NumberParseUtils.fallback(string, clazz);
        }
    }

    private static <T extends Number> T fallback(String string, Class<T> clazz) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(NumberParseUtils.getErrorMessage(string));
        }
        return BigDecimalUtils.getValue(bigDecimal, clazz);
    }

    private static String getErrorMessage(String string) {
        return StringFormatter.format("{} is not a valid number", (Object)string);
    }
}

