/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.util.function.Supplier;
import org.springframework.lang.Nullable;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    @Nullable
    @SafeVarargs
    public static <T> T firstNonNull(T ... TArray) {
        if (TArray != null) {
            for (T t : TArray) {
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    @Nullable
    @SafeVarargs
    public static <T> T getFirstNonNull(Supplier<T> ... supplierArray) {
        if (supplierArray != null) {
            for (Supplier<T> supplier : supplierArray) {
                T t;
                if (supplier == null || (t = supplier.get()) == null) continue;
                return t;
            }
        }
        return null;
    }

    public static boolean anyNull(Object ... objectArray) {
        if (objectArray == null) {
            return true;
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    public static boolean allNull(Object ... objectArray) {
        if (objectArray == null) {
            return true;
        }
        for (Object object : objectArray) {
            if (object == null) continue;
            return false;
        }
        return true;
    }
}

