/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.io.Serializable;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.StringFormatter;

public final class Pair<A, B>
implements Serializable {
    @Nullable
    private final A a;
    @Nullable
    private final B b;

    private Pair(@Nullable A a, @Nullable B b) {
        this.a = a;
        this.b = b;
    }

    public static <A, B> Pair<A, B> ofNullable(@Nullable A a, @Nullable B b) {
        return new Pair<A, B>(a, b);
    }

    public static <A, B> Pair<A, B> ofNonNull(A a, B b) {
        Assert.notNull(a, (String)"a is null");
        Assert.notNull(b, (String)"b is null");
        return new Pair<A, B>(a, b);
    }

    @Nullable
    public A getA() {
        return this.a;
    }

    public A getRequiredA() {
        return Objects.requireNonNull(this.a);
    }

    @Nullable
    public B getB() {
        return this.b;
    }

    public B getRequiredB() {
        return Objects.requireNonNull(this.b);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pair pair = (Pair)object;
        return Objects.equals(this.a, pair.a) && Objects.equals(this.b, pair.b);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public String toString() {
        return StringFormatter.format("({}, {})", this.a, this.b);
    }
}

