/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtils {
    private RandomUtils() {
    }

    public static boolean nextBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static byte[] nextBytes(int n) {
        byte[] byArray = new byte[n];
        ThreadLocalRandom.current().nextBytes(byArray);
        return byArray;
    }

    public static int nextInt(int n, int n2) {
        if (n == n2) {
            return n;
        }
        return n + ThreadLocalRandom.current().nextInt(n2 - n);
    }

    public static int nextInt() {
        return RandomUtils.nextInt(0, Integer.MAX_VALUE);
    }

    public static long nextLong(long l, long l2) {
        if (l == l2) {
            return l;
        }
        return l + RandomUtils.nextLong(l2 - l);
    }

    public static long nextLong() {
        return RandomUtils.nextLong(Long.MAX_VALUE);
    }

    private static long nextLong(long l) {
        long l2;
        long l3;
        while ((l3 = ThreadLocalRandom.current().nextLong() >>> 1) - (l2 = l3 % l) + (l - 1L) < 0L) {
        }
        return l2;
    }

    public static double nextDouble(double d, double d2) {
        if (d == d2) {
            return d;
        }
        return d + (d2 - d) * ThreadLocalRandom.current().nextDouble();
    }

    public static double nextDouble() {
        return RandomUtils.nextDouble(0.0, Double.MAX_VALUE);
    }

    public static float nextFloat(float f, float f2) {
        if (f == f2) {
            return f;
        }
        return f + (f2 - f) * ThreadLocalRandom.current().nextFloat();
    }

    public static float nextFloat() {
        return RandomUtils.nextFloat(0.0f, Float.MAX_VALUE);
    }
}

