/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.util.HashMap;
import java.util.Map;

public final class StringFormatter {
    private static final char DELIM_START = '{';
    private static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    private StringFormatter() {
    }

    public static String format(String string) {
        return string;
    }

    public static String format(String string, Object object) {
        return StringFormatter.format(string, new Object[]{object});
    }

    public static String format(String string, Object ... objectArray) {
        Throwable throwable = StringFormatter.getThrowableCandidate(objectArray);
        Object[] objectArray2 = objectArray;
        if (throwable != null) {
            objectArray2 = StringFormatter.trimmedCopy(objectArray);
        }
        return StringFormatter.format(string, objectArray2, throwable);
    }

    private static String format(String string, Object[] objectArray, Throwable throwable) {
        if (string == null) {
            return null;
        }
        if (objectArray == null) {
            return string;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = string.indexOf(DELIM_STR, n);
            if (n2 == -1) {
                if (n == 0) {
                    return string;
                }
                stringBuilder.append(string, n, string.length());
                return string;
            }
            if (StringFormatter.isEscapedDelimiter(string, n2)) {
                if (!StringFormatter.isDoubleEscaped(string, n2)) {
                    --i;
                    stringBuilder.append(string, n, n2 - 1);
                    stringBuilder.append('{');
                    n = n2 + 1;
                    continue;
                }
                stringBuilder.append(string, n, n2 - 1);
                StringFormatter.deeplyAppendParameter(stringBuilder, objectArray[i], new HashMap<Object[], Object>());
                n = n2 + 2;
                continue;
            }
            stringBuilder.append(string, n, n2);
            StringFormatter.deeplyAppendParameter(stringBuilder, objectArray[i], new HashMap<Object[], Object>());
            n = n2 + 2;
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    private static boolean isEscapedDelimiter(String string, int n) {
        if (n == 0) {
            return false;
        }
        char c = string.charAt(n - 1);
        return c == '\\';
    }

    private static boolean isDoubleEscaped(String string, int n) {
        return n >= 2 && string.charAt(n - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder stringBuilder, Object object, Map<Object[], Object> map) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (!object.getClass().isArray()) {
            StringFormatter.safeObjectAppend(stringBuilder, object);
        } else if (object instanceof boolean[]) {
            StringFormatter.booleanArrayAppend(stringBuilder, (boolean[])object);
        } else if (object instanceof byte[]) {
            StringFormatter.byteArrayAppend(stringBuilder, (byte[])object);
        } else if (object instanceof char[]) {
            StringFormatter.charArrayAppend(stringBuilder, (char[])object);
        } else if (object instanceof short[]) {
            StringFormatter.shortArrayAppend(stringBuilder, (short[])object);
        } else if (object instanceof int[]) {
            StringFormatter.intArrayAppend(stringBuilder, (int[])object);
        } else if (object instanceof long[]) {
            StringFormatter.longArrayAppend(stringBuilder, (long[])object);
        } else if (object instanceof float[]) {
            StringFormatter.floatArrayAppend(stringBuilder, (float[])object);
        } else if (object instanceof double[]) {
            StringFormatter.doubleArrayAppend(stringBuilder, (double[])object);
        } else {
            StringFormatter.objectArrayAppend(stringBuilder, (Object[])object, map);
        }
    }

    private static void safeObjectAppend(StringBuilder stringBuilder, Object object) {
        try {
            String string = object.toString();
            stringBuilder.append(string);
        }
        catch (Throwable throwable) {
            stringBuilder.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder stringBuilder, Object[] objectArray, Map<Object[], Object> map) {
        stringBuilder.append('[');
        if (!map.containsKey(objectArray)) {
            map.put(objectArray, null);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                StringFormatter.deeplyAppendParameter(stringBuilder, objectArray[i], map);
                if (i == n - 1) continue;
                stringBuilder.append(", ");
            }
            map.remove(objectArray);
        } else {
            stringBuilder.append("...");
        }
        stringBuilder.append(']');
    }

    private static void booleanArrayAppend(StringBuilder stringBuilder, boolean[] blArray) {
        stringBuilder.append('[');
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(blArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void byteArrayAppend(StringBuilder stringBuilder, byte[] byArray) {
        stringBuilder.append('[');
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(byArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void charArrayAppend(StringBuilder stringBuilder, char[] cArray) {
        stringBuilder.append('[');
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(cArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void shortArrayAppend(StringBuilder stringBuilder, short[] sArray) {
        stringBuilder.append('[');
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(sArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void intArrayAppend(StringBuilder stringBuilder, int[] nArray) {
        stringBuilder.append('[');
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(nArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void longArrayAppend(StringBuilder stringBuilder, long[] lArray) {
        stringBuilder.append('[');
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(lArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void floatArrayAppend(StringBuilder stringBuilder, float[] fArray) {
        stringBuilder.append('[');
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(fArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void doubleArrayAppend(StringBuilder stringBuilder, double[] dArray) {
        stringBuilder.append('[');
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(dArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
    }

    public static Throwable getThrowableCandidate(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        Object object = objectArray[objectArray.length - 1];
        if (object instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    public static Object[] trimmedCopy(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalStateException("empty or null argument array");
        }
        int n = objectArray.length - 1;
        Object[] objectArray2 = new Object[n];
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        return objectArray2;
    }
}

