/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.CharUtils;
import spring.turbo.util.collection.CollectionUtils;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isBlank(@Nullable String string) {
        return string == null || string.isBlank();
    }

    public static boolean isNotBlank(@Nullable String string) {
        return !StringUtils.isBlank(string);
    }

    public static int length(@Nullable String string) {
        return string == null ? 0 : string.length();
    }

    public static boolean containsWhitespace(String string) {
        Assert.notNull((Object)string, (String)"string is null");
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!CharUtils.isWhitespace(Character.valueOf(string.charAt(i)))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyChars(String string, String string2) {
        Assert.notNull((Object)string, (String)"string is null");
        Set<Character> set = StringUtils.toCharSet(string);
        if (set.isEmpty()) {
            return false;
        }
        return StringUtils.toCharStream(string2).anyMatch(set::contains);
    }

    public static boolean containsAllChars(String string, String string2) {
        Assert.notNull((Object)string, (String)"string is null");
        Set<Character> set = StringUtils.toCharSet(string);
        if (set.isEmpty()) {
            return false;
        }
        return StringUtils.toCharStream(string2).allMatch(set::contains);
    }

    public static boolean containsNoneChars(String string, String string2) {
        Assert.notNull((Object)string, (String)"string is null");
        Set<Character> set = StringUtils.toCharSet(string);
        if (set.isEmpty()) {
            return true;
        }
        return StringUtils.toCharStream(string2).noneMatch(set::contains);
    }

    public static int countMatches(String string, char c) {
        Assert.notNull((Object)string, (String)"string is null");
        if (StringUtils.isEmpty(string)) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (c != string.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    public static String deleteWhitespace(String string) {
        Assert.notNull((Object)string, (String)"string is null");
        if (string.isEmpty()) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            cArray[n2++] = string.charAt(i);
        }
        if (n2 == n) {
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        return new String(cArray, 0, n2);
    }

    public static String deleteChars(String string, String string2) {
        Assert.notNull((Object)string, (String)"string is null");
        if (StringUtils.isEmpty(string2)) {
            return string;
        }
        Set<Character> set = StringUtils.toCharSet(string2);
        StringBuilder stringBuilder = new StringBuilder();
        StringUtils.toCharList(string).stream().filter(c -> !set.contains(c)).forEach(stringBuilder::append);
        return stringBuilder.toString();
    }

    public static Stream<Character> toCharStream(@Nullable String string) {
        if (string == null) {
            return Stream.empty();
        }
        return string.chars().mapToObj(n -> Character.valueOf((char)n));
    }

    public static List<Character> toCharList(@Nullable String string) {
        return StringUtils.toCharStream(string).collect(Collectors.toList());
    }

    public static Set<Character> toCharSet(@Nullable String string) {
        return StringUtils.toCharStream(string).collect(Collectors.toSet());
    }

    public static String reverse(String string) {
        Assert.notNull((Object)string, (String)"string is null");
        return new StringBuilder(string).reverse().toString();
    }

    public static String[] commaDelimitedListToStringArray(@Nullable String string) {
        return StringUtils.commaDelimitedListToStringArray(string, false);
    }

    public static String[] commaDelimitedListToStringArray(@Nullable String string, boolean bl) {
        if (string == null || StringUtils.isBlank(string)) {
            return new String[0];
        }
        String[] stringArray = string.split(",");
        if (bl) {
            return (String[])Arrays.stream(stringArray).map(String::trim).toArray(String[]::new);
        }
        return stringArray;
    }

    public static String capitalize(String string) {
        int n;
        int n2;
        Assert.notNull((Object)string, (String)"string is null");
        int n3 = StringUtils.length(string);
        if (n3 == 0) {
            return string;
        }
        int n4 = string.codePointAt(0);
        if (n4 == (n2 = Character.toTitleCase(n4))) {
            return string;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        nArray[n5++] = n2;
        for (int i = Character.charCount(n4); i < n3; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            nArray[n5++] = n;
        }
        return new String(nArray, 0, n5);
    }

    public static String uncapitalize(String string) {
        int n;
        int n2;
        Assert.notNull((Object)string, (String)"string is null");
        int n3 = StringUtils.length(string);
        if (n3 == 0) {
            return string;
        }
        int n4 = string.codePointAt(0);
        if (n4 == (n2 = Character.toLowerCase(n4))) {
            return string;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        nArray[n5++] = n2;
        for (int i = Character.charCount(n4); i < n3; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            nArray[n5++] = n;
        }
        return new String(nArray, 0, n5);
    }

    public static void nullSafeAdd(Collection<String> collection, @Nullable String string) {
        CollectionUtils.nullSafeAdd(collection, string);
    }

    public static void nullSafeAddAll(Collection<String> collection, String ... stringArray) {
        CollectionUtils.nullSafeAddAll(collection, stringArray);
    }

    public static void nullSafeAddAll(Collection<String> collection, @Nullable Collection<String> collection2) {
        CollectionUtils.nullSafeAddAll(collection, collection2);
    }

    public static void emptySafeAdd(Collection<String> collection, @Nullable String string) {
        StringUtils.emptySafeAddAll(collection, string);
    }

    public static void emptySafeAddAll(Collection<String> collection, String ... stringArray) {
        Assert.notNull(collection, (String)"collection is required");
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!StringUtils.isNotEmpty(string)) continue;
                collection.add(string);
            }
        }
    }

    public static void emptySafeAddAll(Collection<String> collection, @Nullable Collection<String> collection2) {
        Assert.notNull(collection, (String)"collection is required");
        if (collection2 != null) {
            for (String string : collection2) {
                if (!StringUtils.isNotEmpty(string)) continue;
                collection.add(string);
            }
        }
    }

    public static void blankSafeAdd(Collection<String> collection, @Nullable String string) {
        StringUtils.blankSafeAddAll(collection, string);
    }

    public static void blankSafeAddAll(Collection<String> collection, String ... stringArray) {
        Assert.notNull(collection, (String)"collection is required");
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!StringUtils.isNotBlank(string)) continue;
                collection.add(string);
            }
        }
    }

    public static void blankSafeAddAll(Collection<String> collection, @Nullable Collection<String> collection2) {
        Assert.notNull(collection, (String)"collection is required");
        if (collection2 != null) {
            for (String string : collection2) {
                if (!StringUtils.isNotBlank(string)) continue;
                collection.add(string);
            }
        }
    }

    public static String nullSafeJoin(@Nullable Iterable<?> iterable, @Nullable String string) {
        if (iterable == null) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(Objects.requireNonNullElse(string, ""));
        for (Object obj : iterable) {
            if (obj == null) continue;
            stringJoiner.add(String.valueOf(obj));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeJoin(@Nullable Iterator<?> iterator, @Nullable String string) {
        if (iterator == null) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(Objects.requireNonNullElse(string, ""));
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null) continue;
            stringJoiner.add(String.valueOf(obj));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeJoin(@Nullable Object[] objectArray, @Nullable String string) {
        if (objectArray == null) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(Objects.requireNonNullElse(string, ""));
        for (Object object : objectArray) {
            if (object == null) continue;
            stringJoiner.add(String.valueOf(object));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeJoin(@Nullable String[] stringArray, @Nullable String string) {
        if (stringArray == null) {
            return "";
        }
        StringJoiner stringJoiner = new StringJoiner(Objects.requireNonNullElse(string, ""));
        for (String string2 : stringArray) {
            if (string2 == null) continue;
            stringJoiner.add(string2);
        }
        return stringJoiner.toString();
    }

    public static boolean startsWith(@Nullable String string, String string2) {
        Assert.notNull((Object)string2, (String)"prefix is required");
        if (string == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    public static boolean endsWith(@Nullable String string, String string2) {
        Assert.notNull((Object)string2, (String)"suffix is required");
        if (string == null) {
            return false;
        }
        return string.endsWith(string2);
    }

    public static boolean startsWithIgnoreCase(@Nullable String string, String string2) {
        Assert.notNull((Object)string2, (String)"prefix is required");
        return string != null && string.length() >= string2.length() && string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static boolean endsWithIgnoreCase(@Nullable String string, String string2) {
        Assert.notNull((Object)string2, (String)"suffix is required");
        return string != null && string.length() >= string2.length() && string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
    }

    public static String repeat(String string, int n) {
        Assert.notNull((Object)string, (String)"string is required");
        Assert.isTrue((n >= 1 ? 1 : 0) != 0, (String)"n must greater than 0");
        if (n == 1 || string.equals("")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        while (n-- != 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static int compare(@Nullable String string, @Nullable String string2) {
        return StringUtils.compare(string, string2, true);
    }

    public static int compare(@Nullable String string, @Nullable String string2, boolean bl) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return bl ? -1 : 1;
        }
        if (string2 == null) {
            return bl ? 1 : -1;
        }
        return string.compareTo(string2);
    }

    public static int compareIgnoreCase(@Nullable String string, @Nullable String string2) {
        return StringUtils.compareIgnoreCase(string, string2, true);
    }

    public static int compareIgnoreCase(@Nullable String string, @Nullable String string2, boolean bl) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return bl ? -1 : 1;
        }
        if (string2 == null) {
            return bl ? 1 : -1;
        }
        return string.compareToIgnoreCase(string2);
    }

    @Nullable
    public static String firstNonEmpty(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!StringUtils.isNotEmpty(string)) continue;
                return string;
            }
        }
        return null;
    }

    @Nullable
    public static String firstNonBlank(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!StringUtils.isNotBlank(string)) continue;
                return string;
            }
        }
        return null;
    }

    public static String joinWithComma(Collection<?> collection) {
        return StringUtils.join(collection, ",");
    }

    public static String join(Collection<?> collection) {
        return StringUtils.join(collection, null);
    }

    public static String join(Collection<?> collection, @Nullable String string) {
        Assert.notNull(collection, (String)"collection is null");
        return String.join((CharSequence)Objects.requireNonNullElse(string, ""), collection.stream().map(Object::toString).toList());
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return string;
    }

    @Nullable
    public static String blankToNull(@Nullable String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        return string;
    }
}

