/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.Pair;
import spring.turbo.util.StringFormatter;

public final class Tuple<A, B, C>
implements Serializable {
    @Nullable
    private final A a;
    @Nullable
    private final B b;
    @Nullable
    private final C c;

    private Tuple(@Nullable A a, @Nullable B b, @Nullable C c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public static <A, B, C> Tuple<A, B, C> ofNullable(@Nullable A a, @Nullable B b, @Nullable C c) {
        return new Tuple<A, B, C>(a, b, c);
    }

    public static <A, B, C> Tuple<A, B, C> ofNonNull(@NonNull A a, @NonNull B b, @NonNull C c) {
        Assert.notNull(a, (String)"a is required");
        Assert.notNull(b, (String)"b is required");
        Assert.notNull(b, (String)"c is required");
        return new Tuple<A, B, C>(a, b, c);
    }

    public static <A, B, C> Tuple<A, B, C> of(@Nullable Pair<A, B> pair, @Nullable C c) {
        return new Tuple<Object, Object, C>(Optional.ofNullable(pair).map(Pair::getA).orElse(null), Optional.ofNullable(pair).map(Pair::getB).orElse(null), c);
    }

    public static <A, B, C> Tuple<A, B, C> of(@Nullable A a, @Nullable Pair<B, C> pair) {
        return new Tuple<A, Object, Object>(a, Optional.ofNullable(pair).map(Pair::getA).orElse(null), Optional.ofNullable(pair).map(Pair::getB).orElse(null));
    }

    @Nullable
    public A getA() {
        return this.a;
    }

    public A getRequiredA() {
        return Objects.requireNonNull(this.a);
    }

    @Nullable
    public B getB() {
        return this.b;
    }

    public B getRequiredB() {
        return Objects.requireNonNull(this.b);
    }

    @Nullable
    public C getC() {
        return this.c;
    }

    public C getRequiredC() {
        return Objects.requireNonNull(this.c);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)object;
        return Objects.equals(this.a, tuple.a) && Objects.equals(this.b, tuple.b) && Objects.equals(this.c, tuple.c);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b, this.c);
    }

    public String toString() {
        return StringFormatter.format("({}, {}, {})", this.a, this.b, this.c);
    }
}

