/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util;

import java.util.UUID;
import spring.turbo.util.id.IDGeneratorHelper;

public final class UUIDGenerators {
    private UUIDGenerators() {
    }

    public static String v4(boolean bl) {
        String string = UUID.randomUUID().toString();
        return bl ? string.replaceAll("-", "") : string;
    }

    public static String classic32() {
        return UUIDGenerators.v4(true);
    }

    public static String classic36() {
        return UUIDGenerators.v4(false);
    }

    public static String timeBased32() {
        return UUIDGenerators.timeBased(true);
    }

    public static String timeBased36() {
        return UUIDGenerators.timeBased(false);
    }

    public static String timeBased(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(bl ? 32 : 36);
        stringBuilder.append(IDGeneratorHelper.getFormattedHiTime());
        if (!bl) {
            stringBuilder.append("-");
        }
        stringBuilder.append(IDGeneratorHelper.getFormattedLoTime());
        if (!bl) {
            stringBuilder.append("-");
        }
        stringBuilder.append(IDGeneratorHelper.getFormattedIP());
        if (!bl) {
            stringBuilder.append("-");
        }
        stringBuilder.append(IDGeneratorHelper.getFormattedJVM());
        if (!bl) {
            stringBuilder.append("-");
        }
        stringBuilder.append(IDGeneratorHelper.getFormattedCount());
        return stringBuilder.toString();
    }
}

