/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> int length(@Nullable T[] TArray) {
        return TArray != null ? TArray.length : 0;
    }

    public static <T> boolean isNullOrEmpty(@Nullable T[] TArray) {
        return TArray == null || TArray.length == 0;
    }

    public static <T> boolean doseNotContainsAnyElements(@Nullable T[] TArray) {
        if (ArrayUtils.isNullOrEmpty(TArray)) {
            return true;
        }
        for (T t : TArray) {
            if (t == null) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> toArrayList(@Nullable T[] TArray) {
        if (ArrayUtils.isNullOrEmpty(TArray)) {
            return new ArrayList(0);
        }
        return new ArrayList<T>(Arrays.asList(TArray));
    }

    public static <T> List<T> toUnmodifiableList(@Nullable T[] TArray) {
        return Collections.unmodifiableList(ArrayUtils.toArrayList(TArray));
    }

    public static <T> Set<T> toHashSet(@Nullable T[] TArray) {
        if (ArrayUtils.isNullOrEmpty(TArray)) {
            return new HashSet();
        }
        return new HashSet<T>(Arrays.asList(TArray));
    }

    public static <T> Set<T> toUnmodifiableSet(@Nullable T[] TArray) {
        return Collections.unmodifiableSet(ArrayUtils.toHashSet(TArray));
    }

    public static <T> boolean contains(@Nullable T[] TArray, T t) {
        return ArrayUtils.toUnmodifiableSet(TArray).contains(t);
    }

    @Nullable
    public static <T> T[] emptyToNull(@Nullable T[] TArray) {
        if (TArray == null || TArray.length == 0) {
            return null;
        }
        return TArray;
    }
}

