/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import spring.turbo.util.StringFormatter;

public class Attributes
extends LinkedMultiValueMap<String, Object>
implements MultiValueMap<String, Object> {
    public Attributes() {
    }

    public Attributes(@Nullable Map<String, List<Object>> map) {
        if (map != null && !map.isEmpty()) {
            super.putAll(map);
        }
    }

    public Attributes(@Nullable Attributes attributes) {
        this((Map<String, List<Object>>)((Object)attributes));
    }

    public static Attributes newInstance() {
        return new Attributes();
    }

    public static Attributes fromMap(@Nullable Map<String, Object> map) {
        Attributes attributes = new Attributes();
        if (!CollectionUtils.isEmpty(map)) {
            for (String string : map.keySet()) {
                Object object = map.get(string);
                attributes.add(string, object);
            }
        }
        return attributes;
    }

    public static Attributes fromListMap(@Nullable Map<String, List<Object>> map) {
        return new Attributes(map);
    }

    public static Attributes fromAttributes(@Nullable Attributes attributes) {
        return new Attributes(attributes);
    }

    public static Attributes fromMultiValueMap(@Nullable MultiValueMap<String, Object> multiValueMap) {
        Attributes attributes = new Attributes();
        Optional.ofNullable(multiValueMap).ifPresent(arg_0 -> ((Attributes)attributes).addAll(arg_0));
        return attributes;
    }

    @Nullable
    public <T> T findFirst(@NonNull String string) {
        Assert.notNull((Object)string, (String)"key is required");
        return (T)super.getFirst((Object)string);
    }

    @Nullable
    public <T> T findFirstOrDefault(@NonNull String string, @Nullable T t) {
        Assert.notNull((Object)string, (String)"key is required");
        return Optional.ofNullable(this.findFirst(string)).orElse(t);
    }

    @Nullable
    public <T> T findFirstOrDefault(@NonNull String string, @NonNull Supplier<T> supplier) {
        Assert.notNull((Object)string, (String)"key is required");
        return Optional.ofNullable(this.findFirst(string)).orElseGet(supplier);
    }

    @NonNull
    public <T> T findRequiredFirst(@NonNull String string) {
        return this.findRequiredFirst(string, () -> new NoSuchElementException(StringFormatter.format("element not found. key: {}", (Object)string)));
    }

    @NonNull
    public <T> T findRequiredFirst(@NonNull String string, @NonNull Supplier<? extends RuntimeException> supplier) {
        Assert.notNull((Object)string, (String)"key is required");
        Assert.notNull(supplier, (String)"exceptionIfKeyNotFound is required");
        T t = this.findFirst(string);
        if (t == null) {
            throw supplier.get();
        }
        return t;
    }
}

