/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> int size(@Nullable Collection<T> collection) {
        return collection != null ? collection.size() : 0;
    }

    public static <K, V> int size(@Nullable Map<K, V> map) {
        return map != null ? map.size() : 0;
    }

    public static <T> boolean isEmpty(@Nullable Collection<T> collection) {
        return CollectionUtils.size(collection) == 0;
    }

    public static <K, V> boolean isEmpty(@Nullable Map<K, V> map) {
        return CollectionUtils.size(map) == 0;
    }

    public static <T> boolean isNotEmpty(@Nullable Collection<T> collection) {
        return CollectionUtils.size(collection) != 0;
    }

    public static <K, V> boolean isNotEmpty(@Nullable Map<K, V> map) {
        return CollectionUtils.size(map) != 0;
    }

    public static <T> void nullSafeAdd(Collection<T> collection, @Nullable T t) {
        Assert.notNull(collection, (String)"collection is required");
        if (t != null) {
            collection.add(t);
        }
    }

    public static <T> void nullSafeAddAll(Collection<T> collection, @Nullable T[] TArray) {
        Assert.notNull(collection, (String)"collection is required");
        if (TArray != null) {
            for (T t : TArray) {
                Optional.ofNullable(t).ifPresent(collection::add);
            }
        }
    }

    public static <T> void nullSafeAddAll(Collection<T> collection, @Nullable Collection<T> collection2) {
        Assert.notNull(collection, (String)"collection is required");
        if (collection2 != null) {
            for (T t : collection2) {
                Optional.ofNullable(t).ifPresent(collection::add);
            }
        }
    }

    public static <K, V> void nullSafeAddAll(Map<K, V> map, @Nullable Map<K, V> map2) {
        Assert.notNull(map, (String)"map is required");
        if (map2 != null) {
            map.putAll(map2);
        }
    }
}

