/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import spring.turbo.util.collection.CollectionUtils;

public final class ListFactories {
    private ListFactories() {
    }

    @SafeVarargs
    public static <T> List<T> newUnmodifiableList(T ... TArray) {
        return Collections.unmodifiableList(ListFactories.newArrayList(TArray));
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... TArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, TArray);
        return arrayList;
    }

    @SafeVarargs
    public static <T> LinkedList<T> newLinkedList(T ... TArray) {
        return new LinkedList<T>(Arrays.asList(TArray));
    }

    @SafeVarargs
    public static <T> Vector<T> newVector(T ... TArray) {
        return new Vector<T>(Arrays.asList(TArray));
    }

    @SafeVarargs
    public static <T> ArrayList<T> nullSafeNewArrayList(T ... TArray) {
        ArrayList arrayList = new ArrayList();
        CollectionUtils.nullSafeAddAll(arrayList, TArray);
        return arrayList;
    }

    @SafeVarargs
    public static <T> LinkedList<T> nullSafeNewLinkedList(T ... TArray) {
        LinkedList linkedList = new LinkedList();
        CollectionUtils.nullSafeAddAll(linkedList, TArray);
        return linkedList;
    }

    @SafeVarargs
    public static <T> Vector<T> nullSafeNewVector(T ... TArray) {
        Vector vector = new Vector();
        CollectionUtils.nullSafeAddAll(vector, TArray);
        return vector;
    }
}

