/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import spring.turbo.util.collection.CollectionUtils;

public final class SetFactories {
    private SetFactories() {
    }

    @SafeVarargs
    public static <T> Set<T> newUnmodifiableSet(T ... TArray) {
        return Collections.unmodifiableSet(SetFactories.newHashSet(TArray));
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... TArray) {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, TArray);
        return hashSet;
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... TArray) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Collections.addAll(linkedHashSet, TArray);
        return linkedHashSet;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> TreeSet<T> newTreeSet(T ... TArray) {
        TreeSet treeSet = new TreeSet(Comparator.naturalOrder());
        if (TArray != null) {
            Collections.addAll(treeSet, TArray);
        }
        return treeSet;
    }

    @SafeVarargs
    public static <T> TreeSet<T> newTreeSet(Comparator<T> comparator, T ... TArray) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        Collections.addAll(treeSet, TArray);
        return treeSet;
    }

    @SafeVarargs
    public static <T> HashSet<T> nullSafeNewHashSet(T ... TArray) {
        HashSet hashSet = new HashSet();
        CollectionUtils.nullSafeAddAll(hashSet, TArray);
        return hashSet;
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> nullSafeNewLinkedHashSet(T ... TArray) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        CollectionUtils.nullSafeAddAll(linkedHashSet, TArray);
        return linkedHashSet;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> TreeSet<T> nullSafeNewTreeSet(T ... TArray) {
        TreeSet treeSet = new TreeSet(Comparator.naturalOrder());
        CollectionUtils.nullSafeAddAll(treeSet, TArray);
        return treeSet;
    }

    @SafeVarargs
    public static <T> TreeSet<T> nullSafeNewTreeSet(Comparator<T> comparator, T ... TArray) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        CollectionUtils.nullSafeAddAll(treeSet, TArray);
        return treeSet;
    }
}

