/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.lang.Nullable;
import spring.turbo.util.collection.ListFactories;
import spring.turbo.util.collection.iterator.EnumerationIterator;

public final class StreamFactories {
    private StreamFactories() {
    }

    @SafeVarargs
    public static <T> Stream<T> newStream(T ... TArray) {
        return Stream.of(TArray);
    }

    @SafeVarargs
    public static <T> Stream<T> nullSafeNewStream(T ... TArray) {
        return ListFactories.nullSafeNewArrayList(TArray).stream();
    }

    public static <T> Stream<T> newStream(@Nullable Iterator<T> iterator) {
        if (iterator == null) {
            return Stream.empty();
        }
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> newStream(@Nullable Iterator<T> iterator, boolean bl) {
        if (iterator == null) {
            return Stream.empty();
        }
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(spliterator, bl);
    }

    public static <T> Stream<T> newSteam(@Nullable Enumeration<T> enumeration) {
        if (enumeration == null) {
            return Stream.empty();
        }
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(new EnumerationIterator<T>(enumeration), 0);
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> newSteam(@Nullable Enumeration<T> enumeration, boolean bl) {
        if (enumeration == null) {
            return Stream.empty();
        }
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(new EnumerationIterator<T>(enumeration), 0);
        return StreamSupport.stream(spliterator, bl);
    }
}

