/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection.iterator;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.springframework.util.Assert;

public class CompositeComparator<T>
implements Comparator<T> {
    private final List<Comparator<T>> comparators;

    @SafeVarargs
    public CompositeComparator(Comparator<T> ... comparatorArray) {
        Assert.notNull(comparatorArray, (String)"comparators is required");
        Assert.notEmpty((Object[])comparatorArray, (String)"comparators is required");
        Assert.noNullElements((Object[])comparatorArray, (String)"comparators has null element(s)");
        this.comparators = Arrays.asList(comparatorArray);
    }

    @Override
    public int compare(T t, T t2) {
        for (Comparator<T> comparator : this.comparators) {
            int n = comparator.compare(t, t2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }
}

