/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection.iterator;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.springframework.util.Assert;

public class FixedOrderComparator<T>
implements Comparator<T> {
    private final boolean greaterIfMissing;
    private final Object[] array;

    public FixedOrderComparator(List<T> list) {
        this(true, list);
    }

    public FixedOrderComparator(boolean bl, List<T> list) {
        this(bl, list.toArray(new Object[0]));
    }

    public FixedOrderComparator(Object ... objectArray) {
        this(true, objectArray);
    }

    public FixedOrderComparator(boolean bl, Object ... objectArray) {
        Assert.notNull((Object)objectArray, (String)"objs is null");
        Assert.notEmpty((Object[])objectArray, (String)"objs is empty");
        this.greaterIfMissing = bl;
        this.array = objectArray;
    }

    @Override
    public int compare(T t, T t2) {
        int n = this.getOrder(t);
        int n2 = this.getOrder(t2);
        return Integer.compare(n, n2);
    }

    private int getOrder(T t) {
        int n = -1;
        for (int i = 0; i < this.array.length; ++i) {
            if (!Objects.equals(this.array[i], t)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            n = this.greaterIfMissing ? this.array.length : -1;
        }
        return n;
    }
}

