/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.collection.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.springframework.lang.Nullable;

public class SingletonIterator<T>
implements Iterator<T> {
    @Nullable
    private T element;

    public SingletonIterator(@Nullable T t) {
        this.element = t;
    }

    public static <T> SingletonIterator<T> of(@Nullable T t) {
        return new SingletonIterator<T>(t);
    }

    @Override
    public boolean hasNext() {
        return this.element != null;
    }

    @Override
    public T next() {
        if (this.element != null) {
            T t = this.element;
            this.element = null;
            return t;
        }
        throw new NoSuchElementException();
    }
}

