/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.concurrent;

import java.util.concurrent.CountDownLatch;
import org.springframework.util.Assert;
import spring.turbo.util.concurrent.UncheckedInterruptedException;

public final class CountDownLatchUtils {
    private CountDownLatchUtils() {
    }

    public static void await(CountDownLatch countDownLatch) {
        CountDownLatchUtils.await(countDownLatch, false);
    }

    public static void await(CountDownLatch countDownLatch, boolean bl) {
        Assert.notNull((Object)countDownLatch, (String)"countDownLatch is null");
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            if (bl) {
                Thread.currentThread().interrupt();
            }
            throw new UncheckedInterruptedException(interruptedException);
        }
    }

    public static void countDown(CountDownLatch countDownLatch) {
        Assert.notNull((Object)countDownLatch, (String)"countDownLatch is null");
        countDownLatch.countDown();
    }
}

