/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.concurrent;

import spring.turbo.util.UUIDGenerators;

public final class CurrentThreadUtils {
    private CurrentThreadUtils() {
    }

    public static Thread getCurrent() {
        return Thread.currentThread();
    }

    public static String getName() {
        return CurrentThreadUtils.getCurrent().getName();
    }

    public static long getId() {
        try {
            return CurrentThreadUtils.getCurrent().getId();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static Thread.State getState() {
        return CurrentThreadUtils.getCurrent().getState();
    }

    public static boolean isNew() {
        return CurrentThreadUtils.getState() == Thread.State.NEW;
    }

    public static boolean isRunnable() {
        return CurrentThreadUtils.getState() == Thread.State.RUNNABLE;
    }

    public static boolean isWaiting() {
        return CurrentThreadUtils.getState() == Thread.State.WAITING;
    }

    public static boolean isBlocked() {
        return CurrentThreadUtils.getState() == Thread.State.BLOCKED;
    }

    public static boolean isTimedWaiting() {
        return CurrentThreadUtils.getState() == Thread.State.TIMED_WAITING;
    }

    public static boolean isTerminated() {
        return CurrentThreadUtils.getState() == Thread.State.TERMINATED;
    }

    public static boolean isInterrupted() {
        return CurrentThreadUtils.getCurrent().isInterrupted();
    }

    public static String getTrait() {
        return String.format("%s:%06d", SyncAvoid.PSEUDO_VM_ID, CurrentThreadUtils.getId());
    }

    private static class SyncAvoid {
        private static final String PSEUDO_VM_ID = UUIDGenerators.v4(true);

        private SyncAvoid() {
        }
    }
}

