/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.concurrent;

import java.time.Duration;
import org.springframework.util.Assert;
import spring.turbo.util.RandomUtils;
import spring.turbo.util.concurrent.UncheckedInterruptedException;

public final class SleepUtils {
    private SleepUtils() {
    }

    public static void sleep(Duration duration) {
        SleepUtils.sleep(duration, false);
    }

    public static void sleep(Duration duration, boolean bl) {
        Assert.notNull((Object)duration, (String)"duration is required");
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException interruptedException) {
            if (bl) {
                Thread.currentThread().interrupt();
            }
            throw new UncheckedInterruptedException(interruptedException);
        }
    }

    public static void sleepRandomSeconds(long l, long l2) {
        SleepUtils.sleepRandomSeconds(l, l2, false);
    }

    public static void sleepRandomSeconds(long l, long l2, boolean bl) {
        long l3 = RandomUtils.nextLong(l, l2);
        SleepUtils.sleep(Duration.ofSeconds(l3), bl);
    }

    public static void sleepRandomMillis(long l, long l2) {
        SleepUtils.sleepRandomMillis(l, l2, false);
    }

    public static void sleepRandomMillis(long l, long l2, boolean bl) {
        long l3 = RandomUtils.nextLong(l, l2);
        SleepUtils.sleep(Duration.ofMillis(l3), bl);
    }
}

