/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.concurrent;

import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;

public final class ThreadPoolFactories {
    private ThreadPoolFactories() {
    }

    public static ExecutorService createFixed(int n) {
        return Executors.newFixedThreadPool(n);
    }

    public static ExecutorService create(int n, int n2, Duration duration, int n3) {
        return ThreadPoolFactories.create(n, n2, duration, n3, new ThreadPoolExecutor.AbortPolicy());
    }

    public static ExecutorService create(int n, int n2, Duration duration, int n3, @Nullable RejectedExecutionHandler rejectedExecutionHandler) {
        return new ThreadPoolExecutor(n, n2, duration.toMillis(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(n3), Executors.defaultThreadFactory(), rejectedExecutionHandler != null ? rejectedExecutionHandler : new ThreadPoolExecutor.AbortPolicy());
    }
}

