/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.concurrent;

import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import spring.turbo.util.StringFormatter;

public final class ThreadSharedObjects {
    private static final ThreadLocal<Map<Class<?>, Object>> TYPE_HOLDER = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<String, Object>> NAME_HOLDER = ThreadLocal.withInitial(HashMap::new);

    private ThreadSharedObjects() {
    }

    public static <T> void put(Class<T> clazz, T t) {
        TYPE_HOLDER.get().put(clazz, t);
    }

    public static void put(String string, Object object) {
        NAME_HOLDER.get().put(string, object);
    }

    @Nullable
    public static <T> T get(Class<T> clazz) {
        return (T)TYPE_HOLDER.get().get(clazz);
    }

    @Nullable
    public static <T> T get(String string) {
        return (T)NAME_HOLDER.get().get(string);
    }

    public static <T> T required(Class<T> clazz) {
        T t = ThreadSharedObjects.get(clazz);
        if (t == null) {
            String string = StringFormatter.format("Cannot get object of type: '{}'", (Object)clazz.getName());
            throw new IllegalStateException(string);
        }
        return t;
    }

    public static <T> T required(String string) {
        T t = ThreadSharedObjects.get(string);
        if (t == null) {
            String string2 = StringFormatter.format("Cannot get object of name: '{}'", (Object)string);
            throw new IllegalStateException(string2);
        }
        return t;
    }

    public static void remove() {
        TYPE_HOLDER.remove();
        TYPE_HOLDER.set(new HashMap());
        NAME_HOLDER.remove();
        NAME_HOLDER.set(new HashMap());
    }
}

