/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.concurrent;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class ThreadUtils {
    private ThreadUtils() {
    }

    public static Set<Thread> getNonDaemonThreads() {
        return ThreadUtils.getThreads(AsyncVoid.NON_DAEMON);
    }

    public static Set<Thread> getDaemonThreads() {
        return ThreadUtils.getThreads(AsyncVoid.IS_DAEMON);
    }

    public static Set<Thread> getAllThreads() {
        return ThreadUtils.getThreads(AsyncVoid.ANY);
    }

    public static Set<Thread> getThreads(@Nullable Predicate<Thread> predicate) {
        predicate = Objects.requireNonNullElse(predicate, AsyncVoid.ANY);
        return Thread.getAllStackTraces().keySet().stream().filter(predicate).collect(Collectors.toUnmodifiableSet());
    }

    public static Optional<Thread> getById(long l) {
        return ThreadUtils.getById(l, false);
    }

    public static Optional<Thread> getById(long l, boolean bl) {
        if (l < 0L) {
            return Optional.empty();
        }
        Predicate<Thread> predicate = bl ? AsyncVoid.ANY : AsyncVoid.NON_DAEMON;
        return Thread.getAllStackTraces().keySet().stream().filter(predicate).filter(thread -> thread.getId() == l).findFirst();
    }

    public static Optional<Thread> getByName(String string) {
        return ThreadUtils.getByName(string, false);
    }

    public static Optional<Thread> getByName(String string, boolean bl) {
        Assert.hasText((String)string, (String)"name is null or blank");
        Predicate<Thread> predicate = bl ? AsyncVoid.ANY : AsyncVoid.NON_DAEMON;
        return Thread.getAllStackTraces().keySet().stream().filter(predicate).filter(thread -> thread.getName().equals(string)).findFirst();
    }

    private static class AsyncVoid {
        private static final Predicate<Thread> ANY = thread -> true;
        private static final Predicate<Thread> IS_DAEMON = Thread::isDaemon;
        private static final Predicate<Thread> NON_DAEMON = Predicate.not(IS_DAEMON);

        private AsyncVoid() {
        }
    }
}

