/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.crypto;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static byte[] sign(byte[] byArray, String string, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, String string, PublicKey publicKey) {
        try {
            Signature signature = Signature.getInstance(string);
            signature.initVerify(publicKey);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, X509Certificate x509Certificate) {
        return SignatureUtils.verify(byArray, byArray2, x509Certificate.getSigAlgName(), x509Certificate.getPublicKey());
    }
}

