/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.crypto.bundle;

import java.io.Serializable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public interface AsymmetricKeyBundle
extends Serializable {
    public KeyPair getKeyPair();

    public <T extends X509Certificate> T getCertificate();

    default public <T extends PublicKey> T getPublicKey() {
        return (T)this.getKeyPair().getPublic();
    }

    default public <T extends PrivateKey> T getPrivateKey() {
        return (T)this.getKeyPair().getPrivate();
    }

    default public String getAlgorithm() {
        return ((Certificate)this.getCertificate()).getPublicKey().getAlgorithm();
    }

    default public String getSigAlgName() {
        return ((X509Certificate)this.getCertificate()).getSigAlgName();
    }
}

