/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.crypto.bundle;

import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import spring.turbo.core.ResourceUtils;
import spring.turbo.util.crypto.bundle.SymmetricKeyBundle;
import spring.turbo.util.crypto.bundle.SymmetricKeyBundleImpl;
import spring.turbo.util.crypto.keystore.KeyStoreFormat;
import spring.turbo.util.crypto.keystore.KeyStoreHelper;

public class KeyStoreSymmetricKeyBundleFactoryBean
implements FactoryBean<SymmetricKeyBundle>,
InitializingBean {
    private String location;
    private KeyStoreFormat format = KeyStoreFormat.PKCS12;
    private String storepass;
    private String alias;
    private String keypass;
    private SymmetricKeyBundle bundle;

    @NonNull
    public SymmetricKeyBundle getObject() {
        return this.bundle;
    }

    public Class<?> getObjectType() {
        return SymmetricKeyBundle.class;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.location, (String)"location is required");
        Assert.notNull((Object)this.format, (String)"format is required");
        Assert.notNull((Object)this.storepass, (String)"storepass is required");
        Assert.notNull((Object)this.alias, (String)"alias is required");
        Assert.notNull((Object)this.keypass, (String)"keypass is required");
        Resource resource = ResourceUtils.loadResource(this.location);
        try (InputStream inputStream = resource.getInputStream();){
            KeyStore keyStore = KeyStoreHelper.loadKeyStore(inputStream, this.format, this.storepass);
            Object t = KeyStoreHelper.getKey(keyStore, this.alias, this.keypass);
            this.bundle = new SymmetricKeyBundleImpl((Key)t);
        }
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setFormat(KeyStoreFormat keyStoreFormat) {
        this.format = keyStoreFormat;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setKeypass(String string) {
        this.keypass = string;
    }
}

