/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.crypto.bundle;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import spring.turbo.core.ResourceUtils;
import spring.turbo.util.crypto.bundle.AsymmetricKeyBundle;
import spring.turbo.util.crypto.bundle.AsymmetricKeyBundleImpl;
import spring.turbo.util.crypto.pem.PemUtils;

public class PemAsymmetricKeyBundleFactoryBean
implements FactoryBean<AsymmetricKeyBundle>,
InitializingBean {
    private String certificateLocation;
    private String certificateContent = "";
    private String privateKeyLocation;
    private String privateKeyContent = "";
    private String privateKeyPassword;
    private AsymmetricKeyBundle bundle;

    @NonNull
    public AsymmetricKeyBundle getObject() {
        return this.bundle;
    }

    public Class<?> getObjectType() {
        return AsymmetricKeyBundle.class;
    }

    public void afterPropertiesSet() {
        X509Certificate x509Certificate = PemUtils.readX509Certificate(this.getCertContent());
        Object t = PemUtils.readPkcs8PrivateKey(this.getPrivateKeyContent(), this.privateKeyPassword);
        this.bundle = new AsymmetricKeyBundleImpl(new KeyPair(x509Certificate.getPublicKey(), (PrivateKey)t), x509Certificate);
    }

    private String getCertContent() {
        if (StringUtils.hasText((String)this.certificateContent)) {
            return this.certificateContent;
        }
        Assert.notNull((Object)this.certificateLocation, (String)"certificateLocation is required");
        return ResourceUtils.readResourceAsString(this.certificateLocation);
    }

    private String getPrivateKeyContent() {
        if (StringUtils.hasText((String)this.privateKeyContent)) {
            return this.privateKeyContent;
        }
        Assert.notNull((Object)this.privateKeyLocation, (String)"keyLocation is required");
        return ResourceUtils.readResourceAsString(this.privateKeyLocation);
    }

    public void setPrivateKeyContent(String string) {
        this.privateKeyContent = string;
    }

    public void setCertificateLocation(String string) {
        this.certificateLocation = string;
    }

    public void setPrivateKeyLocation(String string) {
        this.privateKeyLocation = string;
    }

    public void setCertificateContent(String string) {
        this.certificateContent = string;
    }

    public void setPrivateKeyPassword(String string) {
        this.privateKeyPassword = string;
    }
}

