/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.crypto.bundle;

import java.security.Key;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import spring.turbo.core.ResourceUtils;
import spring.turbo.util.crypto.bundle.SymmetricKeyBundle;
import spring.turbo.util.crypto.bundle.SymmetricKeyBundleImpl;
import spring.turbo.util.crypto.pem.PemUtils;

public class PemSymmetricKeyBundleFactoryBean
implements FactoryBean<SymmetricKeyBundle>,
InitializingBean {
    private String keyLocation;
    private String keyContent;
    private String keyPassword;
    private SymmetricKeyBundle bundle;

    @NonNull
    public SymmetricKeyBundle getObject() {
        return this.bundle;
    }

    public Class<?> getObjectType() {
        return SymmetricKeyBundle.class;
    }

    public void afterPropertiesSet() {
        Object t = PemUtils.readPkcs8Key(this.getKeyContent(), this.keyPassword);
        this.bundle = new SymmetricKeyBundleImpl((Key)t);
    }

    private String getKeyContent() {
        if (StringUtils.hasText((String)this.keyContent)) {
            return this.keyContent;
        }
        Assert.notNull((Object)this.keyLocation, (String)"keyLocation is required");
        return ResourceUtils.readResourceAsString(this.keyLocation);
    }

    public void setKeyContent(String string) {
        this.keyContent = string;
    }

    public void setKeyLocation(String string) {
        this.keyLocation = string;
    }

    public void setKeyPassword(String string) {
        this.keyPassword = string;
    }
}

