/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.crypto.keystore;

import java.io.Serializable;
import org.springframework.lang.Nullable;

public enum KeyStoreFormat implements Serializable
{
    PKCS12("pkcs12"),
    JKS("JKS");

    private final String value;

    private KeyStoreFormat(String string2) {
        this.value = string2;
    }

    @Nullable
    public static KeyStoreFormat of(@Nullable String string) {
        if (string == null) {
            return null;
        }
        if ("pfx".equalsIgnoreCase(string) || "p12".equalsIgnoreCase(string) || "pkcs#12".equalsIgnoreCase(string) || "pkcs12".equalsIgnoreCase(string)) {
            return PKCS12;
        }
        if ("jks".equalsIgnoreCase(string)) {
            return JKS;
        }
        return null;
    }

    public static KeyStoreFormat getDefault() {
        return PKCS12;
    }

    public String getValue() {
        return this.value;
    }
}

