/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.crypto.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.crypto.keystore.KeyStoreFormat;

public final class KeyStoreHelper {
    private KeyStoreHelper() {
    }

    public static KeyStore loadKeyStore(InputStream inputStream, String string) {
        return KeyStoreHelper.loadKeyStore(inputStream, KeyStoreFormat.PKCS12, string);
    }

    public static KeyStore loadKeyStore(InputStream inputStream, @Nullable KeyStoreFormat keyStoreFormat, String string) {
        Assert.notNull((Object)inputStream, (String)"inputStream is required");
        Assert.notNull((Object)string, (String)"storepass is required");
        keyStoreFormat = Objects.requireNonNullElseGet(keyStoreFormat, KeyStoreFormat::getDefault);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreFormat.getValue());
            keyStore.load(inputStream, string.toCharArray());
            return keyStore;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
    }

    public static <T extends Key> T getKey(KeyStore keyStore, String string, String string2) {
        Assert.notNull((Object)keyStore, (String)"keyStore is required");
        Assert.hasText((String)string, (String)"alias is required");
        Assert.notNull((Object)string2, (String)"privateKeyPass is required");
        try {
            return (T)keyStore.getKey(string, string2.toCharArray());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public static <T extends PrivateKey> T getPrivateKey(KeyStore keyStore, String string, String string2) {
        return (T)((PrivateKey)KeyStoreHelper.getKey(keyStore, string, string2));
    }

    public static <T extends PublicKey> T getPublicKey(KeyStore keyStore, String string) {
        T t = KeyStoreHelper.getCertificate(keyStore, string);
        return (T)((Certificate)t).getPublicKey();
    }

    public static <T extends Certificate> T getCertificate(KeyStore keyStore, String string) {
        Assert.notNull((Object)keyStore, (String)"keyStore is required");
        Assert.hasText((String)string, (String)"alias is required");
        try {
            return (T)keyStore.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalArgumentException(keyStoreException.getMessage(), keyStoreException);
        }
    }

    public static KeyPair getKeyPair(KeyStore keyStore, String string, String string2) {
        return new KeyPair((PublicKey)KeyStoreHelper.getPublicKey(keyStore, string), (PrivateKey)KeyStoreHelper.getPrivateKey(keyStore, string, string2));
    }

    public static String getSigAlgName(KeyStore keyStore, String string) {
        Object t = KeyStoreHelper.getCertificate(keyStore, string);
        if (t instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)t;
            return x509Certificate.getSigAlgName();
        }
        throw new IllegalArgumentException("cannot get SigAlg");
    }

    public static String getSigAlgOID(KeyStore keyStore, String string) {
        Object t = KeyStoreHelper.getCertificate(keyStore, string);
        if (t instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)t;
            return x509Certificate.getSigAlgOID();
        }
        throw new IllegalArgumentException("cannot get SigAlgOID");
    }

    public static boolean containsAlias(KeyStore keyStore, String string) {
        try {
            return keyStore.containsAlias(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new IllegalArgumentException(keyStoreException.getMessage(), keyStoreException);
        }
    }
}

