/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.crypto.pem;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import spring.turbo.util.io.IOExceptionUtils;

public final class PemUtils {
    private PemUtils() {
    }

    public static PemContent load(CharSequence charSequence) {
        Assert.notNull((Object)charSequence, (String)"text is null");
        String string = PemUtils.trimPemContent(charSequence.toString());
        Assert.hasText((String)string, (String)"text is blank");
        return PemContent.of((String)string);
    }

    public static PemContent load(Path path) {
        Assert.notNull((Object)path, (String)"path is null");
        try {
            PemContent pemContent = PemContent.load((Path)path);
            Assert.notNull((Object)pemContent, (String)"content is null");
            return pemContent;
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static PemContent load(File file) {
        Assert.notNull((Object)file, (String)"file is null");
        return PemUtils.load(file.toPath());
    }

    public static PemContent load(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource is null");
        try {
            PemContent pemContent = PemContent.of((String)resource.getContentAsString(StandardCharsets.UTF_8));
            Assert.notNull((Object)pemContent, (String)"content is null");
            return pemContent;
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static X509Certificate readX509Certificate(String string) {
        Assert.hasText((String)string, (String)"text is null or blank");
        string = PemUtils.trimPemContent(string);
        PemContent pemContent = PemContent.of((String)string);
        List list = pemContent.getCertificates();
        if (list.size() == 1) {
            return (X509Certificate)list.get(0);
        }
        throw new IllegalStateException("cannot read a certificate chain");
    }

    public static X509Certificate readX509Certificate(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource is null");
        try {
            return PemUtils.readX509Certificate(resource.getContentAsString(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static List<X509Certificate> readX509Certificates(String string) {
        Assert.hasText((String)string, (String)"text is null or blank");
        string = PemUtils.trimPemContent(string);
        PemContent pemContent = PemContent.of((String)string);
        return new ArrayList<X509Certificate>(pemContent.getCertificates());
    }

    public static List<X509Certificate> readX509Certificates(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource is null");
        try {
            return PemUtils.readX509Certificates(resource.getContentAsString(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static <T extends PrivateKey> T readPkcs8PrivateKey(String string) {
        return PemUtils.readPkcs8PrivateKey(string, null);
    }

    public static <T extends PrivateKey> T readPkcs8PrivateKey(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource is null");
        try {
            return PemUtils.readPkcs8PrivateKey(resource.getContentAsString(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static <T extends PrivateKey> T readPkcs8PrivateKey(String string, @Nullable String string2) {
        return (T)((PrivateKey)PemUtils.readPkcs8Key(string, string2));
    }

    public static <T extends PrivateKey> T readPkcs8PrivateKey(Resource resource, @Nullable String string) {
        Assert.notNull((Object)resource, (String)"resource is null");
        try {
            return PemUtils.readPkcs8PrivateKey(resource.getContentAsString(StandardCharsets.UTF_8), string);
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static <T extends Key> T readPkcs8Key(String string) {
        return PemUtils.readPkcs8Key(string, null);
    }

    public static <T extends Key> T readPkcs8Key(Resource resource) {
        Assert.notNull((Object)resource, (String)"resource is null");
        try {
            return PemUtils.readPkcs8Key(resource.getContentAsString(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static <T extends Key> T readPkcs8Key(String string, @Nullable String string2) {
        Assert.hasText((String)string, (String)"text is null or blank");
        string = PemUtils.trimPemContent(string);
        PemContent pemContent = PemContent.of((String)string);
        return (T)pemContent.getPrivateKey(string2);
    }

    public static <T extends Key> T readPkcs8Key(Resource resource, @Nullable String string) {
        Assert.notNull((Object)resource, (String)"resource is null");
        try {
            return PemUtils.readPkcs8Key(resource.getContentAsString(StandardCharsets.UTF_8), string);
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static String trimPemContent(String string) {
        Assert.hasText((String)string, (String)"text is null or blank");
        return string.lines().map(String::trim).filter(StringUtils::hasText).collect(Collectors.joining("\n")).trim();
    }
}

