/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.hash;

import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.hash.DigestHashFunction;
import spring.turbo.util.hash.HashFunction;

public class ConsistentHashing {
    private final int countOfReplicas;
    private final SortedMap<Integer, String> hashCircle = new TreeMap<Integer, String>();
    private final HashFunction hashFunction;

    public ConsistentHashing(int n) {
        this(n, DigestHashFunction.md5());
    }

    public ConsistentHashing(int n, @Nullable HashFunction hashFunction) {
        Assert.isTrue((n >= 1 ? 1 : 0) != 0, (String)"countOfReplicas must be greater or equals 1");
        this.countOfReplicas = n;
        this.hashFunction = Objects.requireNonNullElseGet(hashFunction, DigestHashFunction::md5);
    }

    public ConsistentHashing addNode(String string) {
        for (int i = 0; i < this.countOfReplicas; ++i) {
            String string2 = string + "&&VN" + i;
            int n = this.hashFunction.apply(string2);
            this.hashCircle.put(n, string);
        }
        return this;
    }

    public String getNode(String string) {
        if (this.hashCircle.isEmpty()) {
            throw new IllegalArgumentException("you should add node first");
        }
        Integer n = this.hashFunction.apply(string);
        SortedMap<Integer, String> sortedMap = this.hashCircle.tailMap(n);
        Integer n2 = sortedMap.isEmpty() ? this.hashCircle.firstKey() : sortedMap.firstKey();
        return (String)this.hashCircle.get(n2);
    }
}

