/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.util.Assert;
import spring.turbo.util.hash.HashFunction;

public class DigestHashFunction
implements HashFunction {
    private final String algName;

    public DigestHashFunction(String string) {
        Assert.hasText((String)string, (String)"algName is null or null");
        this.algName = string;
    }

    public static HashFunction md5() {
        return SyncAvoid.MD5;
    }

    public static HashFunction sha1() {
        return SyncAvoid.SHA1;
    }

    public static HashFunction sha256() {
        return SyncAvoid.SHA256;
    }

    public static HashFunction sha384() {
        return SyncAvoid.SHA384;
    }

    public static HashFunction sha512() {
        return SyncAvoid.SHA512;
    }

    @Override
    public Integer apply(String string) {
        try {
            byte[] byArray = MessageDigest.getInstance(this.algName).digest(string.getBytes());
            return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private static class SyncAvoid {
        private static final HashFunction MD5 = new DigestHashFunction("MD5");
        private static final HashFunction SHA1 = new DigestHashFunction("SHA-1");
        private static final HashFunction SHA256 = new DigestHashFunction("SHA-256");
        private static final HashFunction SHA384 = new DigestHashFunction("SHA-384");
        private static final HashFunction SHA512 = new DigestHashFunction("SHA-512");

        private SyncAvoid() {
        }
    }
}

