/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.id;

import java.net.InetAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class IDGeneratorHelper {
    private static final int IP;
    private static final Lock COUNTER_LOCKER;
    private static final int JVM_STARTUP;
    private static short COUNTER;

    private IDGeneratorHelper() {
    }

    public static int getJVM() {
        return JVM_STARTUP;
    }

    public static String getFormattedJVM() {
        return IDGeneratorHelper.format(JVM_STARTUP);
    }

    public static short getCount() {
        COUNTER_LOCKER.lock();
        try {
            if (COUNTER < 0) {
                COUNTER = 0;
            }
            short s = COUNTER;
            COUNTER = (short)(s + 1);
            short s2 = s;
            return s2;
        }
        finally {
            COUNTER_LOCKER.unlock();
        }
    }

    public static String getFormattedCount() {
        return IDGeneratorHelper.format(IDGeneratorHelper.getCount());
    }

    public static int getIP() {
        return IP;
    }

    public static String getFormattedIP() {
        return IDGeneratorHelper.format(IP);
    }

    public static short getHiTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    public static String getFormattedHiTime() {
        return IDGeneratorHelper.format(IDGeneratorHelper.getHiTime());
    }

    public static int getLoTime() {
        return (int)System.currentTimeMillis();
    }

    public static String getFormattedLoTime() {
        return IDGeneratorHelper.format(IDGeneratorHelper.getLoTime());
    }

    public static String format(int n) {
        String string = Integer.toHexString(n);
        StringBuilder stringBuilder = new StringBuilder("00000000");
        stringBuilder.replace(8 - string.length(), 8, string);
        return stringBuilder.toString();
    }

    public static String format(short s) {
        String string = Integer.toHexString(s);
        StringBuilder stringBuilder = new StringBuilder("0000");
        stringBuilder.replace(4 - string.length(), 4, string);
        return stringBuilder.toString();
    }

    private static int toInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = (n << 8) - -128 + byArray[i];
        }
        return n;
    }

    static {
        int n;
        COUNTER_LOCKER = new ReentrantLock(false);
        JVM_STARTUP = (int)(System.currentTimeMillis() >>> 8);
        COUNTER = 0;
        try {
            n = IDGeneratorHelper.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Throwable throwable) {
            n = 0;
        }
        IP = n;
    }
}

