/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.id;

public class SnowflakeGenerator {
    private final long twepoch = 1420041600000L;
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDataCenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long dataCenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private final long workerId;
    private final long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeGenerator(long l, long l2) {
        if (l > 31L || l < 0L) {
            throw new IllegalArgumentException(String.format("workerId can't be greater than %d or less than 0", 31L));
        }
        if (l2 > 31L || l2 < 0L) {
            throw new IllegalArgumentException(String.format("data centerId can't be greater than %d or less than 0", 31L));
        }
        this.workerId = l;
        this.dataCenterId = l2;
    }

    public synchronized Long nextId() {
        long l = this.timeGen();
        if (l < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - l));
        }
        if (this.lastTimestamp == l) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                l = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = l;
        return l - 1420041600000L << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long l) {
        long l2 = this.timeGen();
        while (l2 <= l) {
            l2 = this.timeGen();
        }
        return l2;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

