/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;

public final class CloseUtils {
    private CloseUtils() {
    }

    public static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(@Nullable AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(@Nullable Resource resource) {
        if (resource != null) {
            try {
                CloseUtils.closeQuietly(resource.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(@Nullable ExecutorService executorService) {
        if (executorService != null) {
            try {
                executorService.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

