/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import spring.turbo.util.io.FileUtils;
import spring.turbo.util.io.IOExceptionUtils;

public final class DirectoryWatcher {
    private final Path directory;
    private final Listener listener;

    private DirectoryWatcher(Path path, Listener listener) {
        this.directory = path;
        this.listener = listener;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void start() {
        try {
            WatchKey watchKey;
            WatchService watchService = FileSystems.getDefault().newWatchService();
            this.directory.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            while ((watchKey = watchService.take()) != null) {
                for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                    this.listener.execute("" + watchEvent.kind(), "" + watchEvent.context());
                }
                watchKey.reset();
            }
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException.getMessage(), interruptedException);
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void execute(String var1, String var2);
    }

    public static final class Builder {
        private Path dir;
        private Listener listener;

        private Builder() {
        }

        public Builder directory(String string, String ... stringArray) {
            this.dir = Paths.get(string, stringArray);
            return this;
        }

        public Builder directory(Path path) {
            this.dir = path;
            return this;
        }

        public Builder directory(File file) {
            this.dir = FileUtils.toPath(file);
            return this;
        }

        public DirectoryWatcher build() {
            return new DirectoryWatcher(this.dir, this.listener);
        }
    }
}

