/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import spring.turbo.util.io.PathUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static Path toPath(File file) {
        return file.toPath();
    }

    public static File createFile(String string, String ... stringArray) {
        return PathUtils.toFile(PathUtils.createPath(string, stringArray));
    }

    public static void createFile(File file) {
        PathUtils.createFile(file.toPath());
    }

    public static void createDirectory(File file) {
        PathUtils.createDirectory(file.toPath());
    }

    public static void move(File file, File file2, boolean bl) {
        PathUtils.move(file.toPath(), file2.toPath(), bl);
    }

    public static void copy(File file, File file2, boolean bl) {
        PathUtils.copy(file.toPath(), file2.toPath(), bl);
    }

    public static void touch(File file) {
        PathUtils.touch(file.toPath());
    }

    public static boolean isExists(File file) {
        return Files.exists(file.toPath(), new LinkOption[0]);
    }

    public static boolean isDirectory(File file) {
        return Files.isDirectory(file.toPath(), new LinkOption[0]);
    }

    public static boolean isEmptyDirectory(File file) {
        return PathUtils.isEmptyDirectory(file.toPath());
    }

    public static boolean isRegularFile(File file) {
        return Files.isRegularFile(file.toPath(), new LinkOption[0]);
    }

    public static boolean isSymbolicLink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    public static boolean isHidden(File file) {
        try {
            return Files.isHidden(file.toPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isReadableAndWritable(File file) {
        return PathUtils.isReadableAndWritable(file.toPath());
    }

    public static boolean isReadable(File file) {
        return PathUtils.isReadable(file.toPath());
    }

    public static boolean isWritable(File file) {
        return PathUtils.isWritable(file.toPath());
    }

    public static boolean isExecutable(File file) {
        return PathUtils.isExecutable(file.toPath());
    }

    public static long size(File file) {
        return PathUtils.size(file.toPath());
    }

    public static void delete(File file) {
        PathUtils.delete(file.toPath());
    }

    public static void deleteQuietly(File file) {
        PathUtils.deleteQuietly(file.toPath());
    }

    public static void cleanDirectory(File file) {
        PathUtils.cleanDirectory(file.toPath());
    }

    public static void cleanDirectoryQuietly(File file) {
        PathUtils.cleanDirectoryQuietly(file.toPath());
    }

    public static Date getCreationTime(File file) {
        return PathUtils.getCreationTime(file.toPath());
    }

    public static Date getLastModifiedTime(File file) {
        return PathUtils.getLastModifiedTime(file.toPath());
    }

    public static Date getLastAccessTime(File file) {
        return PathUtils.getLastAccessTime(file.toPath());
    }

    public static List<String> readLines(File file) {
        return PathUtils.readLines(file.toPath());
    }

    public static List<String> readLines(File file, Charset charset) {
        return PathUtils.readLines(file.toPath(), charset);
    }

    public static byte[] readBytes(File file) {
        return PathUtils.readBytes(file.toPath());
    }

    public static void writeBytes(File file, byte[] byArray, boolean bl, boolean bl2) {
        PathUtils.writeBytes(file.toPath(), byArray, bl, bl2);
    }

    public static void writeLines(File file, List<String> list, boolean bl, boolean bl2) {
        PathUtils.writeLines(file.toPath(), list, bl, bl2);
    }

    public static void writeLines(File file, List<String> list, Charset charset, boolean bl, boolean bl2) {
        PathUtils.writeLines(file.toPath(), list, charset, bl, bl2);
    }

    public static boolean isSameFile(File file, File file2) {
        return PathUtils.isSameFile(file.toPath(), file2.toPath());
    }
}

