/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.nio.file.Paths;
import org.springframework.lang.Nullable;

public final class FilenameUtils {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final int NOT_FOUND = -1;

    private FilenameUtils() {
    }

    public static String normalize(String string) {
        return FilenameUtils.contact(string, new String[0]);
    }

    public static String contact(String string, String ... stringArray) {
        if (stringArray != null) {
            return Paths.get(string, stringArray).normalize().toString();
        }
        return Paths.get(string, new String[0]).normalize().toString();
    }

    public static String getName(String string) {
        FilenameUtils.requireNonNullChars(string);
        int n = FilenameUtils.indexOfLastSeparator(string);
        return string.substring(n + 1);
    }

    public static String getBaseName(String string) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(string));
    }

    public static String getExtension(String string) {
        int n = FilenameUtils.indexOfExtension(string);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String removeExtension(String string) {
        FilenameUtils.requireNonNullChars(string);
        int n = FilenameUtils.indexOfExtension(string);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static int indexOfExtension(@Nullable String string) {
        if (string == null) {
            return -1;
        }
        int n = string.lastIndexOf(46);
        int n2 = FilenameUtils.indexOfLastSeparator(string);
        return n2 > n ? -1 : n;
    }

    private static int indexOfLastSeparator(@Nullable String string) {
        if (string == null) {
            return -1;
        }
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        return Math.max(n, n2);
    }

    private static void requireNonNullChars(String string) {
        if (string.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
    }
}

