/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;

public final class IOUtils {
    private IOUtils() {
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        try {
            return FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static int copy(Reader reader, Writer writer) {
        try {
            return FileCopyUtils.copy((Reader)reader, (Writer)writer);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copy(byte[] byArray, OutputStream outputStream) {
        try {
            StreamUtils.copy((byte[])byArray, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static void copy(String string, OutputStream outputStream) {
        IOUtils.copy(string, null, outputStream);
    }

    public static void copy(String string, @Nullable Charset charset, OutputStream outputStream) {
        charset = Objects.requireNonNullElse(charset, StandardCharsets.UTF_8);
        try {
            StreamUtils.copy((String)string, (Charset)charset, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static byte[] copyToByteArray(InputStream inputStream) {
        try {
            return StreamUtils.copyToByteArray((InputStream)inputStream);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static String copyToString(InputStream inputStream) {
        return IOUtils.copyToString(inputStream, null);
    }

    public static String copyToString(InputStream inputStream, @Nullable Charset charset) {
        charset = Objects.requireNonNullElse(charset, StandardCharsets.UTF_8);
        try {
            return StreamUtils.copyToString((InputStream)inputStream, (Charset)charset);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static int drain(InputStream inputStream) {
        try {
            return StreamUtils.drain((InputStream)inputStream);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

