/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import spring.turbo.util.Base64Utils;
import spring.turbo.util.io.IOExceptionUtils;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static byte[] toByteArray(BufferedImage bufferedImage, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, string, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static String encodeToBase64(BufferedImage bufferedImage, String string) {
        byte[] byArray = ImageUtils.toByteArray(bufferedImage, string);
        byte[] byArray2 = Base64Utils.encode(byArray, false, true);
        return new String(byArray2, StandardCharsets.UTF_8);
    }
}

