/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import spring.turbo.util.collection.StreamFactories;

public final class ManifestUtils {
    private ManifestUtils() {
    }

    public static Manifest getManifest(@Nullable Predicate<URL> predicate) {
        return ManifestUtils.getManifestStream(predicate).findFirst().orElse(null);
    }

    public static Stream<Manifest> getManifestStream(@Nullable Predicate<URL> predicate) {
        try {
            Enumeration<URL> enumeration = ManifestUtils.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            return StreamFactories.newSteam(enumeration, false).filter(Objects.requireNonNullElse(predicate, uRL -> true)).map(new URL2ManifestFunc()).filter(Objects::nonNull);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static class URL2ManifestFunc
    implements Function<URL, Manifest> {
        private URL2ManifestFunc() {
        }

        @Override
        @Nullable
        public Manifest apply(URL uRL) {
            try {
                return new Manifest(uRL.openStream());
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

