/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.springframework.util.Assert;
import spring.turbo.util.StringFormatter;
import spring.turbo.util.io.IOExceptionUtils;
import spring.turbo.util.io.PathUtils;

public final class PathTreeUtils {
    private PathTreeUtils() {
    }

    public static Stream<Path> list(Path path) {
        return PathTreeUtils.list(path, Integer.MAX_VALUE);
    }

    public static Stream<Path> list(Path path, int n) {
        Assert.notNull((Object)path, (String)"path is required");
        Assert.isTrue((n >= 0 ? 1 : 0) != 0, (String)"maxDepth must greater than 0");
        if (!PathUtils.isExists(path)) {
            String string = StringFormatter.format("'{}' not exists", (Object)path);
            throw IOExceptionUtils.toUnchecked(string);
        }
        try {
            return Files.walk(path, n, FileVisitOption.FOLLOW_LINKS);
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }
}

