/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.util.FileSystemUtils;
import spring.turbo.util.StringFormatter;
import spring.turbo.util.collection.ListFactories;
import spring.turbo.util.io.IOExceptionUtils;
import spring.turbo.util.io.PathTreeUtils;

public final class PathUtils {
    private PathUtils() {
    }

    public static File toFile(Path path) {
        return path.toFile();
    }

    public static Path createPath(String string, String ... stringArray) {
        return Paths.get(string, stringArray).normalize();
    }

    public static Path createAbsolutePath(String string, String ... stringArray) {
        return PathUtils.createPath(string, stringArray).toAbsolutePath();
    }

    public static Path createFile(String string, String ... stringArray) {
        Path path = PathUtils.createPath(string, stringArray);
        PathUtils.createFile(path);
        return path;
    }

    public static void createFile(Path path) {
        try {
            boolean bl = PathUtils.toFile(path).createNewFile();
            if (!bl) {
                String string = StringFormatter.format("unable to create file: {}", (Object)path);
                throw IOExceptionUtils.toUnchecked(string);
            }
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static Path createDirectory(String string, String ... stringArray) {
        Path path = PathUtils.createPath(string, stringArray);
        PathUtils.createDirectory(path);
        return path;
    }

    public static void createDirectory(Path path) {
        if (PathUtils.isExists(path)) {
            if (PathUtils.isDirectory(path)) {
                return;
            }
            String string = StringFormatter.format("unable to create dir: {}", (Object)path);
            throw IOExceptionUtils.toUnchecked(string);
        }
        boolean bl = PathUtils.toFile(path).mkdirs();
        if (!bl) {
            String string = StringFormatter.format("unable to create dir: {}", (Object)path);
            throw IOExceptionUtils.toUnchecked(string);
        }
    }

    public static void move(Path path, Path path2, boolean bl) {
        LinkedList<CopyOption> linkedList = ListFactories.newLinkedList(new CopyOption[0]);
        if (bl) {
            linkedList.add(StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            Files.move(path, path2, linkedList.toArray(new CopyOption[0]));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static void copy(Path path, Path path2, boolean bl) {
        LinkedList<CopyOption> linkedList = ListFactories.newLinkedList(new CopyOption[0]);
        if (bl) {
            linkedList.add(StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            Files.copy(path, path2, linkedList.toArray(new CopyOption[0]));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static void touch(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
            } else {
                Files.createFile(path, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static boolean isExists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public static boolean isEmptyDirectory(Path path) {
        boolean bl;
        block9: {
            if (!PathUtils.isDirectory(path)) {
                return false;
            }
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
            try {
                boolean bl2 = bl = !directoryStream.iterator().hasNext();
                if (directoryStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw IOExceptionUtils.toUnchecked(iOException);
                }
            }
            directoryStream.close();
        }
        return bl;
    }

    public static boolean isRegularFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    public static boolean isSymbolicLink(Path path) {
        return Files.isSymbolicLink(path);
    }

    public static boolean isHidden(Path path) {
        try {
            return Files.isHidden(path);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isReadableAndWritable(Path path) {
        return PathUtils.isReadable(path) && PathUtils.isWritable(path);
    }

    public static boolean isReadable(Path path) {
        return Files.isReadable(path);
    }

    public static boolean isWritable(Path path) {
        return Files.isWritable(path);
    }

    public static boolean isExecutable(Path path) {
        return Files.isExecutable(path);
    }

    public static long size(Path path) {
        if (!PathUtils.isExists(path)) {
            throw IOExceptionUtils.toUnchecked("file not exists");
        }
        try {
            return Files.size(path);
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static void delete(Path path) {
        try {
            if (!PathUtils.isExists(path)) {
                return;
            }
            if (PathUtils.isRegularFile(path)) {
                Files.deleteIfExists(path);
            } else {
                FileSystemUtils.deleteRecursively((Path)path);
            }
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static void deleteQuietly(Path path) {
        try {
            PathUtils.delete(path);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void cleanDirectory(Path path) {
        if (!PathUtils.isDirectory(path)) {
            return;
        }
        PathTreeUtils.list(path, 1).forEach(path2 -> {
            if (!path2.equals(path)) {
                PathUtils.delete(path2);
            }
        });
    }

    public static void cleanDirectoryQuietly(Path path) {
        if (!PathUtils.isDirectory(path)) {
            return;
        }
        PathTreeUtils.list(path, 1).forEach(path2 -> {
            if (!path2.equals(path)) {
                PathUtils.deleteQuietly(path2);
            }
        });
    }

    public static Date getCreationTime(Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return new Date(basicFileAttributes.creationTime().to(TimeUnit.MILLISECONDS));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static Date getLastModifiedTime(Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return new Date(basicFileAttributes.lastModifiedTime().to(TimeUnit.MILLISECONDS));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static Date getLastAccessTime(Path path) {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return new Date(basicFileAttributes.lastAccessTime().to(TimeUnit.MILLISECONDS));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static List<String> readLines(Path path) {
        return PathUtils.readLines(path, StandardCharsets.UTF_8);
    }

    public static List<String> readLines(Path path, Charset charset) {
        try {
            return Files.readAllLines(path, charset);
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static void writeBytes(Path path, byte[] byArray, boolean bl, boolean bl2) {
        ArrayList<OpenOption> arrayList = ListFactories.newArrayList(StandardOpenOption.WRITE);
        if (bl) {
            arrayList.add(StandardOpenOption.CREATE);
        }
        if (bl2) {
            arrayList.add(StandardOpenOption.APPEND);
        } else {
            arrayList.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        try {
            Files.write(path, byArray, arrayList.toArray(new OpenOption[0]));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static void writeLines(Path path, List<String> list, boolean bl, boolean bl2) {
        PathUtils.writeLines(path, list, StandardCharsets.UTF_8, bl, bl2);
    }

    public static void writeLines(Path path, List<String> list, Charset charset, boolean bl, boolean bl2) {
        ArrayList<OpenOption> arrayList = ListFactories.newArrayList(StandardOpenOption.WRITE);
        if (bl) {
            arrayList.add(StandardOpenOption.CREATE);
        }
        if (bl2) {
            arrayList.add(StandardOpenOption.APPEND);
        } else {
            arrayList.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        try {
            Files.write(path, list, charset, arrayList.toArray(new OpenOption[0]));
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }

    public static Path toAbsolutePath(Path path) {
        return path.toAbsolutePath();
    }

    public static boolean isSameFile(Path path, Path path2) {
        try {
            return Files.isSameFile(path, path2);
        }
        catch (IOException iOException) {
            throw IOExceptionUtils.toUnchecked(iOException);
        }
    }
}

