/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.io;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import spring.turbo.core.ResourceUtils;
import spring.turbo.util.io.PathUtils;
import spring.turbo.util.io.RichResourceImpl;

public interface RichResource
extends Resource,
Serializable {
    public static RichResource of(Resource resource) {
        return new RichResourceImpl(resource);
    }

    public static RichResource of(String string) {
        Resource resource = ResourceUtils.loadResource(string);
        return new RichResourceImpl(resource);
    }

    default public boolean isPhysicalResource() {
        try {
            this.getFile();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    default public Path getPath() throws IOException {
        return this.getFile().toPath().toAbsolutePath();
    }

    default public Reader getReader() throws IOException {
        return this.getReader(null);
    }

    default public Reader getReader(@Nullable Charset charset) throws IOException {
        return new InputStreamReader(this.getInputStream(), Objects.requireNonNullElse(charset, StandardCharsets.UTF_8));
    }

    default public String getAsText() throws IOException {
        return this.getAsText(null);
    }

    default public String getAsText(@Nullable Charset charset) throws IOException {
        return this.getContentAsString(Objects.requireNonNullElse(charset, StandardCharsets.UTF_8));
    }

    default public Stream<String> getLinesAsStream() throws IOException {
        return this.getLinesAsStream(null);
    }

    default public Stream<String> getLinesAsStream(@Nullable Charset charset) throws IOException {
        charset = Objects.requireNonNullElse(charset, StandardCharsets.UTF_8);
        return this.getAsText(charset).lines();
    }

    default public boolean isRegularFile() {
        try {
            return PathUtils.isRegularFile(this.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    default public boolean isDirectory() {
        try {
            return PathUtils.isDirectory(this.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    default public boolean isEmptyDirectory() {
        try {
            return PathUtils.isEmptyDirectory(this.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    default public boolean isSymbolicLink() {
        try {
            return PathUtils.isSymbolicLink(this.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    default public boolean isHidden() {
        try {
            return PathUtils.isHidden(this.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    default public RichResource createRelativeAsRichResource(String string) throws IOException {
        return new RichResourceImpl(this.createRelative(string));
    }

    public Resource delegating();

    default public Resource toResource() {
        return this.delegating();
    }

    default public Class<? extends Resource> getDelegatingType() {
        return this.delegating().getClass();
    }
}

