/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import org.springframework.util.Assert;

public final class FieldPredicateFactories {
    private FieldPredicateFactories() {
    }

    public static Predicate<Field> alwaysTrue() {
        return field -> true;
    }

    public static Predicate<Field> alwaysFalse() {
        return field -> false;
    }

    public static Predicate<Field> not(Predicate<Field> predicate) {
        Assert.notNull(predicate, (String)"predicate is required");
        return field -> !predicate.test((Field)field);
    }

    @SafeVarargs
    public static Predicate<Field> any(Predicate<Field> ... predicateArray) {
        Assert.notNull(predicateArray, (String)"predicates is required");
        Assert.isTrue((predicateArray.length >= 1 ? 1 : 0) != 0, (String)"predicates must greater than 1");
        return field -> {
            for (Predicate predicate : predicateArray) {
                if (!predicate.test(field)) continue;
                return true;
            }
            return false;
        };
    }

    @SafeVarargs
    public static Predicate<Field> all(Predicate<Field> ... predicateArray) {
        Assert.notNull(predicateArray, (String)"predicates is required");
        Assert.isTrue((predicateArray.length >= 1 ? 1 : 0) != 0, (String)"predicates must greater than 1");
        return field -> {
            for (Predicate predicate : predicateArray) {
                if (predicate.test(field)) continue;
                return false;
            }
            return true;
        };
    }

    public static Predicate<Field> isCopyableField() {
        return field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }

    public static Predicate<Field> isNotCopyableField() {
        return FieldPredicateFactories.not(FieldPredicateFactories.isCopyableField());
    }

    public static Predicate<Field> withAnnotation(Class<? extends Annotation> clazz) {
        return field -> field.getAnnotation(clazz) != null;
    }

    public static Predicate<Field> withoutAnnotation(Class<? extends Annotation> clazz) {
        return FieldPredicateFactories.not(FieldPredicateFactories.withAnnotation(clazz));
    }

    public static Predicate<Field> isPublic() {
        return field -> Modifier.isPublic(field.getModifiers());
    }

    public static Predicate<Field> isNotPublic() {
        return FieldPredicateFactories.not(FieldPredicateFactories.isPublic());
    }

    public static Predicate<Field> isPrivate() {
        return field -> Modifier.isPrivate(field.getModifiers());
    }

    public static Predicate<Field> isNotPrivate() {
        return FieldPredicateFactories.not(FieldPredicateFactories.isPrivate());
    }

    public static Predicate<Field> isProtected() {
        return field -> Modifier.isProtected(field.getModifiers());
    }

    public static Predicate<Field> isNotProtected() {
        return FieldPredicateFactories.not(FieldPredicateFactories.isProtected());
    }

    public static Predicate<Field> isStatic() {
        return field -> Modifier.isStatic(field.getModifiers());
    }

    public static Predicate<Field> isNotStatic() {
        return FieldPredicateFactories.not(FieldPredicateFactories.isStatic());
    }

    public static Predicate<Field> isFinal() {
        return field -> Modifier.isFinal(field.getModifiers());
    }

    public static Predicate<Field> isNotFinal() {
        return FieldPredicateFactories.not(FieldPredicateFactories.isFinal());
    }
}

