/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.reflection;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.reflection.InstanceUtils;
import spring.turbo.util.reflection.InstantiationExceptionSupplier;

public final class InstanceCache {
    private final Map<Class<?>, Object> map = new HashMap();
    @Nullable
    private final ApplicationContext applicationContext;
    @Nullable
    private final BeanFactory beanFactory;

    private InstanceCache(@Nullable ApplicationContext applicationContext, @Nullable BeanFactory beanFactory) {
        this.applicationContext = applicationContext;
        this.beanFactory = beanFactory;
    }

    public static InstanceCache newInstance() {
        return new InstanceCache(null, null);
    }

    public static InstanceCache newInstance(@Nullable ApplicationContext applicationContext) {
        return new InstanceCache(applicationContext, null);
    }

    public static InstanceCache newInstance(@Nullable BeanFactory beanFactory) {
        return new InstanceCache(null, beanFactory);
    }

    public InstanceCache add(Class<?> clazz, Object object) {
        Assert.notNull(clazz, (String)"type is required");
        Assert.notNull((Object)object, (String)"instance is required");
        this.map.put(clazz, object);
        return this;
    }

    public synchronized <T> T findOrCreate(Class<?> clazz) {
        return this.findOrCreate(clazz, new InstantiationExceptionSupplier(clazz));
    }

    public synchronized <T> T findOrCreate(Class<?> clazz, Supplier<? extends RuntimeException> supplier) {
        Assert.notNull(clazz, (String)"type is required");
        Assert.notNull(supplier, (String)"exceptionIfCannotCreateInstance is required");
        Object object = this.findFromApplicationContext(clazz);
        if (object != null) {
            return (T)object;
        }
        object = this.findFromBeanFactory(clazz);
        if (object != null) {
            return (T)object;
        }
        object = this.map.get(clazz);
        if (object == null) {
            object = InstanceUtils.newInstanceElseThrow(clazz, supplier);
            this.map.put(clazz, object);
        }
        return (T)object;
    }

    @Nullable
    private Object findFromApplicationContext(Class<?> clazz) {
        if (this.applicationContext == null) {
            return null;
        }
        ObjectProvider objectProvider = this.applicationContext.getBeanProvider(clazz);
        try {
            return objectProvider.getIfAvailable();
        }
        catch (BeansException beansException) {
            return null;
        }
    }

    @Nullable
    private Object findFromBeanFactory(Class<?> clazz) {
        if (this.beanFactory == null) {
            return null;
        }
        try {
            return this.beanFactory.getBean(clazz);
        }
        catch (BeansException beansException) {
            return null;
        }
    }
}

